<?php
/**
 * @author: Nexi Payments SpA
 * @copyright: © 2017, Nexi Payments SpA
 * @license: GNU General Public License v3.0
 */

class NexiXPayRedirectModuleFrontController extends ModuleFrontController
{

    public function postProcess()
    {
        $cart = $this->context->cart;
        if ($cart->id_customer == 0 || $cart->id_address_delivery == 0 ||
                $cart->id_address_invoice == 0 || !$this->module->active) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        $authorized = false;
        foreach (Module::getPaymentModules() as $module) {
            if ($module['name'] == 'nexixpay') {
                $authorized = true;
                break;
            }
        }
        if (!$authorized) {
            die($this->module->l('This payment method is not available.'));
        }

        $customer = new Customer($cart->id_customer);
        if (!Validate::isLoadedObject($customer)) {
            Tools::redirect('index.php?controller=order&step=1');
        }

        $paymentGateway = $this->module->getConfiguration();

        $rfo = new NexiXPayRequest($paymentGateway->url_pagina_cassa);

        $rfo->setAlias($paymentGateway->nexi_alias);
        $rfo->setMacKey($paymentGateway->nexi_mac);
        $rfo->setMail($customer->email);
        $rfo->setDescrizione("Cliente: " . $customer->firstname . " " . $customer->lastname);
       
        $total = (float) $cart->getOrderTotal(true, Cart::BOTH);
        $totalTemp = ($total * 100);
        if (stripos($totalTemp, ".") !== false) {
            $res = Tools::substr($totalTemp, 0, stripos($totalTemp, "."));
        } else {
            $res = $totalTemp;
        }
        $rfo->setImporto($res);

        $name = str_replace("www.", "", Configuration::get('PS_SHOP_NAME'));

        preg_replace('/[^A-Za-z0-9 ]/', '', $name);
        $name = Tools::substr(Tools::strtolower($name), 0, 4);
        $name = str_replace(" ", "", $name);
        $rfo->setCodTrans($name . rand(10000, 99999) . '_' . $cart->id);

        if ($paymentGateway->nexi_form_language == "AUTO") {
            $lingue = array(
                'it' => 'ITA',
                'fr' => 'FRA',
                'de' => 'GER',
                'es' => 'SPA',
                'jp' => 'JPG',
                'cn' => 'CHI',
                'ar' => 'ARA',
                'ru' => 'RUS',
                'gb' => 'ENG',
                'en' => 'ENG',
                'us' => 'ENG',
                'pr' => 'POR'
            );
            
            if (Tools::strtolower($this->context->language->iso_code)) {
                $lang = $lingue[Tools::strtolower($this->context->language->iso_code)];
            } else {
                $lang = "ITA";
            }
        } else {
            $lang = $paymentGateway->nexi_form_language;
        }

        $rfo->setLanguageId($lang);

        $rfo->setSessionId(session_id());

        $rfo->setUrl($paymentGateway->url);

        $rfo->setUrlBack($paymentGateway->url_back);
        $rfo->setUrlpost($paymentGateway->urlpost);

        $rfo->calculateUrlRedirect();

        echo $rfo->getUrlRedirect();
        Tools::redirect($rfo->getUrlRedirect());
    }
}
